% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setExit.R
\name{setExit}
\alias{setExit}
\title{Sets the exit date, if there is no exit column in the table}
\usage{
setExit(ped, time.origin = as.Date("1970-01-01"))
}
\arguments{
\item{ped}{dataframe of pedigree and demographic information potentially
containing columns indicating the birth and death dates of an individual.
The table may also contain dates of sale (departure). Optional columns
are \code{birth}, \code{death}, and \code{departure}.}

\item{time.origin}{date object used by \code{as.Date} to set \code{origin}.}
}
\value{
A dataframe with an updated pedigree with exit dates specified based
on date information that was available.
}
\description{
Part of Pedigree Curation
}
\examples{
\donttest{
library(lubridate)
library(nprcgenekeepr)
death <- mdy(paste0(sample(1:12, 10, replace = TRUE), "-",
                    sample(1:28, 10, replace = TRUE), "-",
                    sample(seq(0, 15, by = 3), 10, replace = TRUE) + 2000))
departure <- as.Date(rep(NA, 10), origin = as.Date("1970-01-01"))
departure[c(1, 3, 6)] <- as.Date(death[c(1, 3, 6)],
                                 origin = as.Date("1970-01-01"))
death[c(1, 3, 5)] <- NA
death[6] <- death[6] + days(1)
ped <- data.frame(
  id = paste0(100 + 1:10),
  birth = mdy(paste0(sample(1:12, 10, replace = TRUE), "-",
                     sample(1:28, 10, replace = TRUE), "-",
                     sample(seq(0, 20, by = 3), 10, replace = TRUE) + 1980)),
  death = death,
  departure = departure,
  stringsAsFactors = FALSE)
pedWithExit <- setExit(ped)
}
}
