% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.nproc.R
\name{lines.nproc}
\alias{lines.nproc}
\title{Add NP-ROC curves to the current plot object.}
\usage{
\method{lines}{nproc}(x, ...)
}
\arguments{
\item{x}{fitted NP-ROC object using \code{nproc}.}

\item{...}{additional arguments.}
}
\description{
Add NP-ROC curves to the current plot object.
}
\examples{
n = 1000
x = matrix(rnorm(n*2),n,2)
c = 1+3*x[,1]
y = rbinom(n,1,1/(1+exp(-c)))
fit = nproc(x, y, method = 'nb')
plot(fit)
fit2 = nproc(x, y, method = 'lda')
lines(fit2, col = 2)
}
\seealso{
\code{\link{npc}}, \code{\link{nproc}} and \code{\link{plot.nproc}}.
}

