% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kriging.R
\name{np.kriging}
\alias{np.kriging}
\alias{kriging}
\alias{np.kriging.default}
\alias{np.kriging.np.geo}
\alias{kriging.simple}
\alias{kriging.simple.solve}
\title{Nonparametric (residual) kriging}
\usage{
np.kriging(object, ...)

\method{np.kriging}{default}(object, svm, lp.resid = NULL,
  ngrid = object$grid$n, ...)

\method{np.kriging}{np.geo}(object, ngrid = object$grid$n, ...)

kriging.simple(x, y, newx, svm)

kriging.simple.solve(x, newx, svm)
}
\arguments{
\item{object}{object used to select a method: 
local polynomial estimate of the trend (class \code{\link{locpol.bin}}) 
or nonparametric geostatistical model (class extending \code{\link{np.geo}}).}

\item{...}{further arguments passed to or from other methods.}

\item{svm}{semivariogram model (of class extending \code{\link{svarmod}}).}

\item{lp.resid}{residuals (defaults to \code{residuals(object)}).}

\item{ngrid}{number of grid nodes in each dimension.}

\item{x}{a (data) object used to select a method.}

\item{y}{vector of data (response variable).}

\item{newx}{vector/matrix with the (irregular) locations to predict 
(columns correspond with dimensions and rows with locations) 
or an object extending \code{\link{grid.par}}-\code{\link{class}}
(\code{\link{data.grid}}).}
}
\description{
Compute simple kriging or residual kriging predictions 
(and also the corresponding simple kriging standard errors  
). Currently, only global (residual) simple kriging is implemented.
}
\seealso{
\code{\link{np.fitgeo}}, \code{\link{locpol}}, \code{\link{np.svar}}.
}
