% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_maxU_and_minimaxU.R
\name{dmaxU}
\alias{dmaxU}
\alias{pmaxU}
\alias{emaxU}
\title{Maximum observed time}
\usage{
dmaxU(x, arm, include_cens = T)

pmaxU(q, arm, include_cens = T, lower.tail = T)

emaxU(arm, include_cens = T)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{arm}{object of class 'arm'.}

\item{include_cens}{logical; if TRUE, include time-to-censoring as potential
observed time; otherwise, observed time equals time-to-event.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P(X \le x)};
otherwise, \eqn{P(X > x)}.}
}
\value{
\code{dmaxU} gives the density, \code{pmaxU} gives the distribution
  function, and \code{emaxU} gives the expected value.
}
\description{
Density, distribution function, and expected value for the maximum observed
time in a single arm of patients.
}
\details{
Given a patient's time-to-event \eqn{T_i} and time-to-censoring
\eqn{C_i}, \eqn{U_i=\min(T_i, C_i)} defines the patient's observed time. The
maximum observed time over patients of a single arm is then \eqn{\max_i U_i}.
}
\seealso{
\code{\link{create_arm}} and \code{\link{create_arm_lachin}}
  for creating an object of class 'arm'.
}
