% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lhd}
\alias{lhd}
\title{Local Health Districts of NSW.}
\format{
An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 15 rows and 11 columns.
}
\source{
Spatial Services, Department of Customer Service NSW.
"MyHospitals_Public",
\url{https://portal.spatial.nsw.gov.au/portal/home/item.html?id=78df4a3e987b4e7e8b241ee5bfeee358}, accessed 4 May 2023.
Republished from
NSW Ministry of Health, "Map of local health districts",
\url{https://www.health.nsw.gov.au/lhd/Pages/lhd-maps.aspx}.

The original dataset is published under the \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International} licence,
© State of New South Wales NSW Ministry of Health 2023. For current information go to \url{https://www.health.nsw.gov.au}.
}
\usage{
lhd
}
\description{
The geometries have been simplified with a tolerance of 1 km to reduce the
level of detail.
}
\examples{
library(ggplot2)
ggplot(lhd) + geom_sf(aes(fill = lhd_name), show.legend = FALSE)
}
\keyword{datasets}
