% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsweibull.R
\name{Neutrosophic Weibull}
\alias{Neutrosophic Weibull}
\alias{dnsweibull}
\alias{pnsweibull}
\alias{qnsweibull}
\alias{rnsweibull}
\title{Neutrosophic Weibull Distribution}
\usage{
dnsweibull(x, shape, scale)

pnsweibull(q, shape, scale, lower.tail = TRUE)

qnsweibull(p, shape, scale)

rnsweibull(n, shape, scale)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{shape}{shape parameter, which must be a positive interval.}

\item{scale}{scale parameter, which must be a positive interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsweibull} gives the distribution function,
 \code{dnsweibull} gives the density,
 \code{qnsweibull} gives the quantile function and
 \code{rnsweibull} generates random variables from the neutrosophic Weibull dDistribution.
}
\description{
Density, distribution function, quantile function and random
generation for the neutrosophic Weibull distribution with \code{scale}
parameter \eqn{\alpha_N} and \code{shape} parameter \eqn{\beta_N}.
}
\details{
The neutrosophic Rayleigh distribution with parameters
\eqn{\alpha_N} and \eqn{\beta_N} has the density
\deqn{f_N(x)=\frac{\beta_N}{\alpha_N^{\beta_N}} x^{\beta_N-1}
    \exp\{-\left(x / \alpha_N\right)^{\beta_N}\}}
for \eqn{\beta_N \in (\beta_L, \beta_U)} the shape parameter must
be a positive interval, \eqn{\alpha_N \in (\alpha_L,\alpha_U)},
the scale parameter which be a positive interval, and \eqn{x > 0}.
}
\examples{
data(remission)
dnsweibull(x = remission, shape = c(1.0519, 1.0553), scale = c(9.3370, 9.4544))

pnsweibull(q = 20, shape = c(1.0519, 1.0553), scale = c(9.3370, 9.4544))

# Calculate quantiles
qnsweibull(p = c(0.25, 0.5, 0.75), shape = c(1.0519, 1.0553), scale = c(9.3370, 9.4544))

# Simulate 10 numbers
rnsweibull(n = 10, shape = c(1.0519, 1.0553), scale = c(9.3370, 9.4544))

}
\references{
Alhasan, K. F. H. and Smarandache, F. (2019). Neutrosophic Weibull
   distribution and Neutrosophic Family Weibull Distribution,
   \emph{Neutrosophic Sets and Systems}, 28, 191-199.
}
