% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{labbcat.getLayers}
\alias{labbcat.getLayers}
\title{Gets a list of layer definitions.}
\usage{
labbcat.getLayers(labbcat)
}
\arguments{
\item{labbcat}{A LaBB-CAT instance object previously created by a call to labbcat.instance}
}
\value{
A list of layer definitions, with members:
\enumerate{
 \item{id The layer's unique ID}
 \item{parentId The layer's parent layer ID}
 \item{description The description of the layer}
 \item{alignment The layer's alignment - 0 for none, 1 for point alignment, 2 for interval alignment}
 \item{peers Whether children have peers or not}
 \item{peersOverlap Whether child peers can overlap or not}
 \item{parentIncludes Whether the parent t-includes the child}
 \item{saturated Whether children must temporally fill the entire parent duration (true) or not (false)}
 \item{parentIncludes Whether the parent t-includes the child}
 \item{type The type for labels on this layer}
 \item{validLabels List of valid label values for this layer}
}
}
\description{
Gets a list of layer definitions.
}
\examples{
## Connect to LaBB-CAT
labbcat <- labbcat.instance("https://labbcat.canterbury.ac.nz/demo/", "demo", "demo")

## Get definitions of all layers
layers <- labbcat.getLayerIds(labbcat)

}
\seealso{
\code{\link{labbcat.getLayerIds}}
}
\keyword{layer}
