% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{getGraphIds}
\alias{getGraphIds}
\title{Gets a list of graph IDs.}
\usage{
getGraphIds(labbcat.url)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}
}
\value{
A list of graph IDs
}
\description{
Returns a list of graph IDs (i.e. transcript names).
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## specify the username/password in the script
## (only use labbcatCredentials for scripts that must execute unsupervised!)
labbcatCredentials(labbcat.url, "demo", "demo")

## List all transcripts
transcripts <- getGraphIds(labbcat.url)
}

}
\keyword{graph}
\keyword{transcript}
