% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_normal.R
\name{get_pi}
\alias{get_pi}
\title{Get the Prior Probability of States}
\usage{
get_pi(mat_T = NULL)
}
\arguments{
\item{mat_T}{(matrix) transition matrix}
}
\value{
A numeric vector
}
\description{
Calculate the prior probability of states that correspond to the stationary
distribution of the transition matrix T
}
\details{
It is assumed that the prior probability of states corresponds
to the stationary distribution of the transition matrix \eqn{T},
denoted with \eqn{\pi} and its entries with \eqn{\pi_i=Pr(\theta_{l-1}=i)}.
}
\examples{
T_mat <- rbind(c(1-0.01,0.01,0),
               c(0.01,1-0.02,0.01),
               c(0,0.01,1-0.01))
T_mat
get_pi(T_mat)
}
