% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_longterm_future_predictions}
\alias{example_longterm_future_predictions}
\title{Example Longterm Future Predictions Data}
\format{
A data frame with 23 rows and 18 columns:
\describe{
\item{\code{country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{year}}{The year of the observation.}
\item{\code{avg_hourly_demand}}{The average hourly electricity demand (in megawatts) for the respective year.}
\item{\code{population}}{The total population in the respective year.}
\item{\code{GDP}}{Gross Domestic Product (in constant 2015 USD) in the respective year.}
\item{\code{industrial_value_added}}{The percentage of GDP attributed to industrial value-added activities.}
\item{\code{manufacturing_value_added}}{The percentage of GDP attributed to manufacturing value-added activities.}
\item{\code{GDP_growth}}{The GDP growth rate (in percentage) for the respective year.}
\item{\code{GDP_deflator}}{The GDP deflator (in percentage), which measures price inflation or deflation.}
\item{\code{service_value_added}}{The percentage of GDP attributed to service sector value-added activities.}
\item{\code{GNI}}{Gross National Income (in constant 2015 USD) in the respective year.}
\item{\code{household_consumption_expenditure}}{The percentage of GDP attributed to household consumption expenditure.}
\item{\code{rural_population}}{The rural population in the respective year.}
\item{\code{longterm_model_predictions1}}{Predictions for the long-term trend component of electricity demand based on Model 1.}
\item{\code{longterm_model_predictions2}}{Predictions for the long-term trend component of electricity demand based on Model 2.}
\item{\code{longterm_model_predictions3}}{Predictions for the long-term trend component of electricity demand based on Model 3.}
\item{\code{test_set_steps}}{The number of years used in the test or validation set for the model evaluation.}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}
@source Demand predictions until 2021: \code{\link{long_term_lm}}; Demand predictions from 2022-2028: \code{\link{long_term_future}} ;World Economic Outlook Database (April 2023 edition) of the International Monetary Fund (IMF) (https://www.imf.org/en/Publications/WEO/weo-database/2023/October); World Development Indicators (WDI) of the World Bank (https://databank.worldbank.org/source/world-development-indicators); Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/); ENTSO-E Power Stats Archive of https://www.entsoe.eu/data/power-stats/
}
\usage{
example_longterm_future_predictions
}
\description{
This dataset extends the long-term trend from \code{\link{example_longterm_predictions}} until the year 2028.
}
\keyword{dataset}
\keyword{longterm}
\keyword{prediction}
