% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestors.R
\name{ancestors}
\alias{ancestors}
\alias{ancestors.rtree}
\title{Ancestors of a node}
\usage{
ancestors(.node, .tree, include_node = FALSE)

\method{ancestors}{rtree}(.node, .tree, include_node = FALSE)
}
\arguments{
\item{.node}{node or character. The node or node label considered.}

\item{.tree}{A tree.}

\item{include_node}{logical. If \code{FALSE} (the default), \code{.node} is not part 
of the list returned.}
}
\value{
A (possibly empty) list of nodes.
}
\description{
The function \code{ancestors} returns the ancestors
of a node in a given tree.
}
\examples{
## Rooted tree
(tr0 = c_("Bob", "Carl", "Daniel"))
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))
(tr2 = r_("Alice", s = list(tr0, tr1)))
ancestors("Alice", tr2)
ancestors("Daniel", tr2, include_node = TRUE)

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son"))))
ancestors("Alice", tr3)
ancestors("Alice", tr3, include_node = TRUE)
ancestors("Daniel", tr3)
ancestors("Son", tr3)
ancestors("Son", tr3, include_node = TRUE)

}
