% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching-engine.R
\name{eventMatch}
\alias{eventMatch}
\title{Match Market Orders (takers) to Limit Orders (makers).}
\usage{
eventMatch(events, cut.off.ms = 5000)
}
\arguments{
\item{events}{data frame of order book events.}

\item{cut.off.ms}{events occuring outside of this time (in milliseconds) 
will be considered as candidate matches.}
}
\description{
Matches corresponding Bid(s) and Ask(s) for each trade event.
}
\details{
A trade event (a market impact) will generate a list of volume change events.
This function will line up 2 time ordered event lists for each side of the
book and attempt to align them by matching volume. If the result contains 
duplicate matches, then the matching is treated as a sequence alignment 
problem, and the Needleman-Wunsch algorithm is applied. As such, the
function acts as a type of "one shot" matching engine, simulating an order
book matching engine without the need to reconstruct the whole book.
}
\examples{

asTime <- function(s) as.POSIXct(s, tz="UTC")
events <- data.frame(timestamp=c(asTime("2015-10-10 21:32:00.000"),
                                 asTime("2015-10-10 21:32:00.010"),
                                 asTime("2015-10-10 21:32:10.000"),
                                 asTime("2015-10-10 21:32:10.010")),
                      direction=c("bid", "ask", "bid", "ask"),
                      event.id=c(1, 2, 3, 4),
                      fill=rep(1234, 4))
matched <- obAnalytics:::eventMatch(events, cut.off.ms=1000)

}
\author{
phil
}
\keyword{internal}

