% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_payouts.R
\name{calc_payout_dm}
\alias{calc_payout_dm}
\title{Calculate expected payout to the decision maker}
\usage{
calc_payout_dm(pr_guess, pay_dm)
}
\arguments{
\item{pr_guess}{A vector of probabilities that the observer will guess.}

\item{pay_dm}{The pay to the decision maker if the observer does not guess.}
}
\value{
A vector of expected payouts for each possible guess made by the
 observer
}
\description{
The function calculates the expected payout to the decision maker. The payout
to the decision maker depends on whether or not the observer tries to guess
the rule, and the monetary payout for choosing an action that leaves the 
observer clueless enough about the rule to refrain from guessing. The 
function is meant for internal use only. To calculate the payout to the 
decision maker, use the wrapper function \code{\link{calculate_payouts}}.
}
