% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{inspect}
\alias{inspect}
\title{Inspect observations}
\usage{
inspect(.data, ob, cols = "all")
}
\arguments{
\item{.data}{A tbl or data frame.}

\item{ob}{integer. A row of the \code{observations} attribute to be inspected.}

\item{cols}{character. One of \code{"all"}, \code{"most"}, \code{"some"}. 
If \code{cols = "all"}, all \code{.data} columns are kept in the result. 
If \code{cols = "some"}, only columns that are concerned by the 
observation \code{ob} are kept. 
\code{cols = "most"} is like \code{cols = "some"}, except that 
columns which are of type \code{"character"} or \code{"factor"} are also 
kept.}
}
\description{
Once a table has been observed with \code{observe_if}, one may wish to dig 
into the observations made. The function \code{inspect} returns a sub-table 
of \code{.data} whose rows correspond to the rows identified by the 
observation \code{ob}.
}
\examples{
library(magrittr)

df <- data.frame(id = c("a", "b", "c"), x = 1:3, y = 2:4, z = c(1.1, 10, 5))
df <- df \%>\% 
  observe_if(z==floor(z), 
             y-x==1, 
             x < 3) \%>\% 
  observe_if(y < 4, 
             x > 1)
  
print(obs(df))

df1 <- df \%>\%  
  inspect(ob = 5, cols="most")
print(obs(df1))

}
\seealso{
\code{\link[observer]{observe_if}} in this package.
}

