% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{.checkfields}
\alias{.checkfields}
\title{Checking main fields}
\usage{
.checkfields(dat, xf, yf, ef, tf, lf, cf, idf, verbose = FALSE)
}
\arguments{
\item{dat}{A dataframe containing occurrence data for checking.}

\item{xf}{character. Name of the field where the x coordinate is stored (typically longitude). Default is x.field}

\item{yf}{character. Name of the field where the y coordinate is stored (typically latitude). Default is y.field}

\item{ef}{character. Name of the field where the elevation of data collection is stored in the original dataset. Default is e.field.}

\item{tf}{character. Name of the field where the date of data collection is stored in the original dataset. Default is t.field.}

\item{lf}{character. Name of the field where the toponim/location of data collection is stored in the original dataset. Default is l.field.}

\item{cf}{character. Name of the field where the registered country of data collection is stored in the original dataset. Default is c.field.}

\item{idf}{character. Name of the field of the id of the observation}

\item{verbose}{logical. Print messages? Default to FALSE}
}
\value{
Original dataframe, dat.  Used primarily to generate warning messages.
}
\description{
Checking main fields
}
\details{
checking main fields (inspired by \link[biogeo]{addmainfields} .
}
\seealso{
Other checks: 
\code{\link{.addmainfields2}()},
\code{\link{.check.geospatial.data}()},
\code{\link{.checkdatastr2}()},
\code{\link{.status.tracker.and.escaping}()}
}
\author{
Mark Robertson and Vernon Visser (original function), Josep M Serra Diaz (modifs)
}
\concept{checks}
