% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/questionnaire_pages.R
\name{page_followup}
\alias{page_followup}
\title{Show potential followup questions to the user.}
\usage{
page_followup(index, is_interview = FALSE, ...)
}
\arguments{
\item{index}{The index of the followup question (1-based).
To show the first followup question (if there are any) use
page_followup(index = 1), to show a potential second followup question use
page_followup(index = 2).
For example \code{\link[=questionnaire_web_survey]{questionnaire_web_survey()}} uses
\verb{..., page_followup(index = 1), page_followup(index = 2), ...}}

\item{is_interview}{Should the page show slightly different / additional
instructions and answer options for an interview that is conducted by
another person? Defaults to FALSE.}

\item{...}{All additional parameters are passed to \code{\link[=new_page]{new_page()}}}
}
\value{
A page object.
}
\description{
To disambiguate between similar occupations. Depending on the suggestion,
multiple followup questions can be shown.
}
\examples{
my_questionnaire <- list(
  page_first_freetext(),
  page_second_freetext(),
  page_select_suggestion(),
  page_none_selected_freetext(),
  page_followup(1),
  page_followup(2)
)
if (interactive()) {
  app(questionnaire = my_questionnaire)
}
}
\seealso{
\code{\link[=new_page]{new_page()}}
}
