\name{section}

\docType{data}

\alias{section}

\title{Hydrographic section}

\description{This is line A03 (ExpoCode 90CT40_1, with nominal sampling date
    1993-09-11).  The chief scientist was Tereschenkov of SOI, working aboard
    the Russian ship Multanovsky, undertaking a westward transect from the
    Mediterranean outflow region across to North America, with a change of
    heading in the last few dozen stations to run across the nominal Gulf
    Stream axis.}

\examples{
\dontrun{
library(oce)
# Gulf Stream
data(section)
GS <- subset(section, 109<=stationId&stationId<=129)
GSg <- sectionGrid(GS, p=seq(0, 5000, 100))
plot(GSg, map.xlim=c(-80,-60))
}
}

\usage{data(section)}

\source{This is based on the WOCE file named \code{a03_hy1.csv}, downloaded
    from \url{http://cchdo.ucsd.edu/cruise/90CT40_1}, 13 April 2015.}

\seealso{The documentation for \code{\link{section-class}} explains the
    structure of \code{section} objects, and also outlines the functions
    dealing with them.}

\author{Dan Kelley}

\keyword{datasets}
