% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map2lonlat}
\alias{map2lonlat}
\title{Convert X and Y to Longitude and Latitude}
\usage{
map2lonlat(x, y, init = c(0, 0))
}
\arguments{
\item{x}{vector containing the x component of points in the projected space, or
a list containing items named \code{x} and \code{y}, in which case the next
argument is ignored.}

\item{y}{vector containing the y coordinate of points in the projected space
(ignored if \code{x} is a list, as described above).}

\item{init}{vector containing the initial guesses for longitude and latitude,
presently ignored.}
}
\value{
A list containing \code{longitude} and \code{latitude}, with \code{NA}
values indicating points that are off the globe as displayed.
}
\description{
Convert from x-y coordinates to longitude and latitude. This is normally called
internally within oce; see \sQuote{Bugs}.
}
\details{
A projection must already have been set up, by a call to \code{\link{mapPlot}}
or \code{\link{lonlat2map}}. It should be noted that not all projections are
handled well; see \sQuote{Bugs}.
}
\section{Bugs}{

\code{oce} uses \link[rgdal]{project} in the \CRANpkg{rgdal}
package to handle projections. Only those projections that have inverses are
permitted within \code{oce}, and even those can sometimes yield errors, owing
to limitations in \CRANpkg{rgdal}.
}
\examples{
\dontrun{
library(oce)
## Cape Split, in the Minas Basin of the Bay of Fundy
cs <- list(longitude=-64.49657,latitude=45.33462)
xy <- lonlat2map(cs, projection="+proj=merc")
map2lonlat(xy)
}

}
\author{
Dan Kelley
}
\seealso{
\code{\link{lonlat2map}} does the inverse operation.

A map must first have been created with \code{\link{mapPlot}}.

Other functions related to maps: \code{\link{lonlat2map}},
  \code{\link{lonlat2utm}}, \code{\link{mapArrows}},
  \code{\link{mapAxis}}, \code{\link{mapContour}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}},
  \code{\link{mapLongitudeLatitudeXY}},
  \code{\link{mapMeridians}}, \code{\link{mapPlot}},
  \code{\link{mapPoints}}, \code{\link{mapPolygon}},
  \code{\link{mapScalebar}}, \code{\link{mapText}},
  \code{\link{mapTissot}}, \code{\link{mapZones}},
  \code{\link{shiftLongitude}}, \code{\link{utm2lonlat}}
}

