% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\name{toEnuAdv}
\alias{toEnuAdv}
\title{Convert an ADV Object to ENU Coordinates}
\usage{
toEnuAdv(x, declination = 0, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{an \linkS4class{adv} object.}

\item{declination}{magnetic declination to be added to the heading, to get
ENU with N as "true" north.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Convert an ADV Object to ENU Coordinates
}
\references{
\enumerate{
\item \verb{https://nortek.zendesk.com/hc/en-us/articles/360029820971-How-is-a-Coordinate-transformation-done-}
}
}
\seealso{
See \code{\link[=read.adv]{read.adv()}} for notes on functions relating to
\code{"adv"} objects.  Also, see \code{\link[=beamToXyzAdv]{beamToXyzAdv()}} and
\code{\link[=xyzToEnuAdv]{xyzToEnuAdv()}}.

Other things related to adv data: 
\code{\link{[[,adv-method}},
\code{\link{[[<-,adv-method}},
\code{\link{adv-class}},
\code{\link{adv}},
\code{\link{beamName}()},
\code{\link{beamToXyz}()},
\code{\link{enuToOtherAdv}()},
\code{\link{enuToOther}()},
\code{\link{plot,adv-method}},
\code{\link{read.adv.nortek}()},
\code{\link{read.adv.sontek.adr}()},
\code{\link{read.adv.sontek.serial}()},
\code{\link{read.adv.sontek.text}()},
\code{\link{read.adv}()},
\code{\link{rotateAboutZ}()},
\code{\link{subset,adv-method}},
\code{\link{summary,adv-method}},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdv}()},
\code{\link{xyzToEnu}()}
}
\author{
Dan Kelley
}
\concept{things related to adv data}
