% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/astronomy.R
\name{julianDay}
\alias{julianDay}
\title{Convert a Time to a Julian Day}
\usage{
julianDay(
  t,
  year = NA,
  month = NA,
  day = NA,
  hour = NA,
  min = NA,
  sec = NA,
  tz = "UTC"
)
}
\arguments{
\item{t}{a time, in POSIXt format, e.g. as created by
\code{\link[=as.POSIXct]{as.POSIXct()}}, \code{\link[=as.POSIXlt]{as.POSIXlt()}}, or
\code{\link[=numberAsPOSIXct]{numberAsPOSIXct()}}, or a character string that can be
converted to a time using \code{\link[=as.POSIXct]{as.POSIXct()}}.  If \code{t} is provided,
the other arguments are ignored.}

\item{year}{year, to be provided along with \code{month}, etc., if \code{t}
is not provided.}

\item{month}{numerical value for the month, with January being 1.
(This is required if \code{t} is not provided.)}

\item{day}{numerical value for day in month, starting at 1.
(This is required if \code{t} is not provided.)}

\item{hour}{numerical value for hour of day, in range 0 to 24.
(This is required if \code{t} is not provided.)}

\item{min}{numerical value of the minute of the hour.
(This is required if \code{t} is not provided.)}

\item{sec}{numerical value for the second of the minute.
(This is required if \code{t} is not provided.)}

\item{tz}{timezone}
}
\value{
A Julian-Day number, in astronomical convention as explained in
Meeus.
}
\description{
Convert a POSIXt time (given as either the \code{t} argument
or as the \code{year}, \code{month}, and other arguments) to a Julian day,
using the method provided in
Chapter 3 of Meeus (1982).  It should be noted that
Meeus and other astronomical treatments use fractional days, whereas the
present code follows the R convention of specifying days in whole numbers,
with hours, minutes, and seconds also provided as necessary.  Conversion is
simple, as illustrated in the example for 1977 April 26.4, for which Meeus
calculates julian day 2443259.9.  Note that the R documentation for
\code{\link[=julian]{julian()}} suggests another formula, but the point of the present
function is to match the other Meeus formulae, so that suggestion is ignored
here.
}
\examples{
library(oce)
# example from Meeus
t <- ISOdatetime(1977, 4, 26, hour = 0, min = 0, sec = 0, tz = "UTC") + 0.4 * 86400
stopifnot(all.equal(julianDay(t), 2443259.9))

}
\references{
\itemize{
\item Meeus, Jean. Astronomical Formulas for Calculators. Second Edition.
Richmond, Virginia, USA: Willmann-Bell, 1982.
}
}
\seealso{
Other things related to astronomy: 
\code{\link{angle2hms}()},
\code{\link{eclipticalToEquatorial}()},
\code{\link{equatorialToLocalHorizontal}()},
\code{\link{julianCenturyAnomaly}()},
\code{\link{moonAngle}()},
\code{\link{siderealTime}()},
\code{\link{sunAngle}()},
\code{\link{sunDeclinationRightAscension}()}

Other things related to time: 
\code{\link{ctimeToSeconds}()},
\code{\link{julianCenturyAnomaly}()},
\code{\link{numberAsHMS}()},
\code{\link{numberAsPOSIXct}()},
\code{\link{secondsToCtime}()},
\code{\link{unabbreviateYear}()}
}
\author{
Dan Kelley
}
\concept{things related to astronomy}
\concept{things related to time}
