% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceSurv2WRMW.R
\name{oceSurv2WRMW}
\alias{oceSurv2WRMW}
\title{Converts Survival Fits to Win Ratio and Mann-Whitney Estimates}
\usage{
oceSurv2WRMW(time0, surv0, time1, surv1)
}
\arguments{
\item{time0}{vector of times for group=0 subset}

\item{surv0}{vector of survival distribution values for group=0}

\item{time1}{vector of times for group=1 subset}

\item{surv1}{vector of survival distribution values for group=1}
}
\value{
A list with the following elements (where Yg=ordered composite endpoint score for group=g):
\describe{
 \item{int01}{estimate of P[Y0>Y1]}
 \item{int10}{estimate of P[Y1>Y0]}
 \item{WR}{win ratio, int10/int01}
 \item{MW}{estimate of P[Y1>Y0]+(1/2)P[Y1=Y0]}
 }

WR=WR,MW=MW,int10=int10,int01=int01
}
\description{
Converts Survival Fits to Win Ratio and Mann-Whitney Estimates
}
\details{
This is an interval function called by \code{\link{oceNPMLE}} or
\code{\link{oceCoxph}}.
}
\keyword{internal}
