% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odbc-data-sources.R
\name{odbcListDataSources}
\alias{odbcListDataSources}
\title{List Configured Data Source Names}
\usage{
odbcListDataSources()
}
\value{
A data frame with two columns:
\describe{
\item{name}{Name of the data source. The entries in this column can be
passed to the \code{dsn} argument of \code{\link[=dbConnect]{dbConnect()}}.}
\item{description}{Data source description.}
}
}
\description{
Collect information about the available data source names (DSNs). A DSN must
be both installed and configured with the driver manager to be included in
this list. Configuring a DSN just sets up a lookup table (e.g. in
\code{odbc.ini}) to allow users to pass only the DSN to \code{\link[=dbConnect]{dbConnect()}}.

DSNs that are not configured with the driver manager can still be
connected to with \code{\link[=dbConnect]{dbConnect()}} by providing DSN metadata directly.
}
\section{Configuration}{


This function interfaces with the driver manager to collect information
about the available data source names.

For \strong{MacOS and Linux}, the odbc package supports the unixODBC driver
manager. unixODBC looks to the \code{odbc.ini} \emph{configuration file} for information
on DSNs. Find the location(s) of your \code{odbc.ini} file(s) with \code{odbcinst -j}.

In this example \code{odbc.ini} file:

\if{html}{\out{<div class="sourceCode">}}\preformatted{[MySQL]
Driver = MySQL Driver
Database = test
Server = 127.0.0.1
User = root
password = root
Port = 3306
}\if{html}{\out{</div>}}

...the data source name is \code{MySQL}, which will appear in the \code{name}
column of this function's output. To pass the DSN as the \code{dsn} argument to
\code{\link[=dbConnect]{dbConnect()}}, pass it as a string, like \code{"MySQL"}.
\verb{Driver = MySQL Driver} references the driver \code{name} in \code{\link[=odbcListDrivers]{odbcListDrivers()}}
output.

\strong{Windows} is \href{https://learn.microsoft.com/en-us/sql/odbc/admin/odbc-data-source-administrator}{bundled}
with an ODBC driver manager.

When a DSN is configured with a driver manager, information on the DSN will
be automatically passed on to \code{\link[=dbConnect]{dbConnect()}} when its \code{dsn} argument is set.

For example, with the \code{MySQL} data source name configured, and the driver
name \verb{MySQL Driver} appearing in \code{\link[=odbcListDrivers]{odbcListDrivers()}} output, the code:

\if{html}{\out{<div class="sourceCode">}}\preformatted{con <-
  dbConnect(
    odbc::odbc(),
    Driver = "MySQL Driver",
    Database = "test",
    Server = "127.0.0.1",
    User = "root",
    password = "root",
    Port = 3306
  )
}\if{html}{\out{</div>}}

...can be written:

\if{html}{\out{<div class="sourceCode">}}\preformatted{con <- dbConnect(odbc::odbc(), dsn = "MySQL")
}\if{html}{\out{</div>}}

In this case, \code{dbConnect()} will look up the information defined for \code{MySQL}
in the driver manager (in our example, \code{odbc.ini}) and automatically
pass the needed arguments.
}

\seealso{
\code{\link[=odbcListDrivers]{odbcListDrivers()}}
}
