% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.2.R
\name{power.2}
\alias{power.2}
\title{Required budget, power, MDES, required sample size calculation for two-level GRTs}
\usage{
power.2(cost.model = TRUE, expr = NULL, constraint = NULL,
  sig.level = 0.05, two.tailed = TRUE, es = NULL, n = NULL, J = NULL,
  p = NULL, m = NULL, power = NULL, q = NULL, ICC = NULL,
  R12 = NULL, R22 = NULL, c1 = NULL, c2 = NULL, c1t = NULL,
  c2t = NULL, eslim = NULL, mlim = NULL, powerlim = NULL, Jlim = NULL)
}
\arguments{
\item{cost.model}{logical, perform power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, perform conventional power analyses
(e.g., required sample size, power, or MDES) if FALSE; default is TRUE.}

\item{expr}{returns from the function of \code{\link{od.2}}; default is NULL;
if \code{expr} is specified, parameter values of \code{ICC},
\code{R12}, \code{R22},
\code{c1}, \code{c2}, \code{c1t}, \code{c2t}, \code{n}, and \code{p}
used or solved in the function of \code{\link{od.2}} will
be passed to the current function;
 only the values of \code{n} and \code{p} that specified or solved in
 the function of \code{\link{od.2}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{specify the values of n and/or p to overwrite those
from \code{expr}; default is NULL.}

\item{sig.level}{significance level or type I error rate, default is 0.05.}

\item{two.tailed}{logical; TRUE for two-tailed tests,
FALSE for one-tailed tests; default is TRUE.}

\item{es}{effect size.}

\item{n}{the average level-1 sample size per level-2 unit.}

\item{J}{the level-2 sample size across treatment conditions.}

\item{p}{the proportion of level-2 units assigned to treatment.}

\item{m}{total budget.}

\item{power}{statistical power.}

\item{q}{the number of level-2 covariates, default is 0.}

\item{ICC}{the unconditional intraclass correlation coefficient in population or in
each treatment condition.}

\item{R12}{the proportion level-1 variance explained by covariates in population or in
each treatment condition.}

\item{R22}{the proportion level-2 variance explained by covariates in population or in
each treatment condition.}

\item{c1}{the cost of sampling one level-1 unit in control condition.}

\item{c2}{the cost of sampling one level-2 unit in control condition.}

\item{c1t}{the cost of sampling one level-1 unit in treatment condition.}

\item{c2t}{the cost of sampling one level-2 unit in treatment condition.}

\item{eslim}{the range to search the root of effect size (es) numerically,
default is c(0, 5)}

\item{mlim}{the range for searching the root of budget (m) numerically,
default is the costs for sampling same number of level-2 units across treatment conditions
or c(4 * Jcost
, 10e10 * Jcost), with Jcost = ((1 - p) * (c1 * n + c2) + p * (c1t * n + c2t))}

\item{powerlim}{the range for searching the root of power (power) numerically,
default is c(1e-10, 1 - 1e-10)}

\item{Jlim}{the range for searching the root of level-2 sample size (J) numerically,
default is c(4, 10e10)}
}
\value{
Required budget / sample size, statistical power, or MDES
    depending on the parameter specification.
    The function also returns the function name, design type,
    and the list of parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power,
    power or the minimum detectable effect size (MDES) under fixed budget
    for two-level group randomized trials (GRTs).
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDES calculation).
}
\examples{
# unconstrained optimal design
myod1 <- od.2(ICC = 0.2, R12 = 0.5, R22 = 0.5, c1 = 1, c2 = 5, c1t = 1, c2t = 50)
myod1$out   # n = 8.9, p = 0.33

# ------- power analyses by default considering costs and budget -------
mym <- power.2(expr = myod1, es = 0.3, q = 1, power = 0.8)
mym$out  # m =1702

mymdes <- power.2(expr = myod1, q = 1, power = 0.80, m = 1702)
mymdes$out  # MDES = 0.30

mypower <- power.2(expr = myod1, q = 1, es = 0.3, m = 1702)
mypower$out  # power = 0.80

# ------- conventional power analyses with cost.model = FALSE-------
# Required J
myJ1 <- power.2(cost.model = FALSE, expr = myod1, es = 0.3, q = 1, power = 0.8)
myJ1$out  # J = 59
myJ1$par  # parameters and their values used for the function

# or equivalently, specify every arguments in the function
myJ1.1 <- power.2(cost.model = FALSE, es = 0.3, power = 0.8, ICC = 0.2,
                  R12 = 0.5, R22 = 0.5, n = 9, p = 0.33, q = 1)
myJ1.1$out

# power
 mypower1 <- power.2(cost.model = FALSE, expr = myod1, J = 59, es = 0.3, q = 1)
mypower1$out  # power = 0.80

# MDES
mymdes1 <- power.2(cost.model = FALSE, expr = myod1, J = 59, power = 0.8, q = 1)
mymdes1$out  # es = 0.30


}
\references{
Shen, Z., & Kelcey, B. (under review). Optimal design of cluster
    randomized trials under condition- and unit-specific cost structures.
    2018 American Educational Research Association (AERA) annual conference.
}
