% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oes_prep.R
\name{oes_prep}
\alias{oes_prep}
\title{Prepare Model Output for OES Plots}
\usage{
oes_prep(
  model,
  treatment_vars = NULL,
  treatment_arms = NULL,
  scale = c("response", "percentage"),
  treatment_labels,
  control_label,
  alpha_level = 0.05
)
}
\arguments{
\item{model}{An object of class \code{lm} or \code{lm_robust}}

\item{treatment_vars}{An optional character vector of treatment arm names. One
of \code{treatment_vars} or \code{treatment_arms} must be supplied.}

\item{treatment_arms}{An optional numeric value indicating the number of treatment
arms. (Not required if treatment_vars is given explicitly.) One
of \code{treatment_vars} or \code{treatment_arms} must be supplied.}

\item{scale}{String indicating the \eqn{y}-axis scale. Default is \code{'response'}.
For binary outcomes, it may be desirable to set to \code{"percentage"}.}

\item{treatment_labels}{Optional vector of string labels providing treatment condition(s)}

\item{control_label}{Optional string providing control condition label}

\item{alpha_level}{The level at which to reject the null hypothesis for adding
asterisks to plots. Set to 0.05 by default. This value also determines the size
of the confidence intervals (\code{alpha_level = 0.05} corresponds to 95\% confidence
intervals).}
}
\value{
A tibble of \eqn{T+1} rows and 8 columns, where \eqn{T} is the number
of treatment conditions specified via \code{treatment_vars} or
\code{treatment_arms}.
}
\description{
Prepare output of linear modeling object into a tidy data table to feed
into OES plotting function
}
\details{
\code{oes_prep()} takes a linear modeling output object (from \code{lm()}
or \code{lm_robust()}) and returns a tidy tibble of estimates,
confidence bounds, and related quantities ready for oes_plot to plot.
Functionality for \code{lm_lin()} objects is in development.
}
\examples{

data(df_oes)

# Single binary treatment:
fit <- lm(y1 ~ x1, df_oes)

# Multiple treatment conditions:
fit2 <- lm(y2 ~ x2, df_oes)

# Using HC2 SE's from lm_robust():
fit_robust <- estimatr::lm_robust(y1 ~ x1, df_oes)
fit_robust2 <- estimatr::lm_robust(y2 ~ x2, df_oes)

# Using covariates and lm():
fit_covars <- lm(y2 ~ x2 + z1 + z2 + z3, df_oes)

# Using covariates and lm_robust():
fit_covars_robust <- estimatr::lm_robust(y2 ~ x2 + z1 + z2 + z3, df_oes)

# Example specifying number of treatment arms:
oes_prep(fit, treatment_arms = 1)

# Example specifying name of treatment variable:
oes_prep(fit, treatment_vars = "x1")

# Example reporting outcomes as percentages:
oes_prep(fit, treatment_vars = "x1", scale = "percentage")

# Example specifying several treatment arms, labels, etc.:
oes_prep(fit2, treatment_arms = 3,
  treatment_labels = c(
    "Email",
    "Email +\nReward",
    "Email +\nRisk"),
  control_label = "Status Quo",
  scale = "percentage")

# Examples with lm_robust():
oes_prep(fit_robust, treatment_arms = 1)
oes_prep(fit_robust2, treatment_arms = 3)

# Examples with covariates:
oes_prep(fit_covars, treatment_arms = 3)
oes_prep(fit_covars_robust, treatment_arms = 3)

}
\author{
Miles Williams
}
