% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with.R
\name{ph_with_ul}
\alias{ph_with_ul}
\title{add unordered list to a pptx presentation}
\usage{
ph_with_ul(x, type, index = 1, str_list = character(0),
  level_list = integer(0), style = NULL)
}
\arguments{
\item{x}{rpptx object}

\item{type}{placeholder type}

\item{index}{placeholder index (integer). This is to be used
when a placeholder type is not unique in the current slide,
e.g. two placeholders with type 'body'.}

\item{str_list}{list of strings to be included in the object}

\item{level_list}{list of levels for hierarchy structure}

\item{style}{text style, a \code{fp_text} object list or a
single \code{fp_text} objects. Use \code{fp_text(font.size = 0, ...)} to
inherit from default sizes of the presentation.}
}
\description{
add an unordered list of text
into an rpptx object. Each text is associated with
a hierarchy level.
}
\examples{
library(magrittr)
pptx <- read_pptx()
pptx <- add_slide(x = pptx, layout = "Title and Content", master = "Office Theme")
pptx <- ph_with_text(x = pptx, type = "title", str = "Example title")
pptx <- ph_with_ul(
  x = pptx, type = "body", index = 1,
  str_list = c("Level1", "Level2", "Level2", "Level3", "Level3", "Level1"),
  level_list = c(1, 2, 2, 3, 3, 1),
  style = fp_text(color = "red", font.size = 0) )
print(pptx, target = "example2.pptx") \%>\%
  invisible()
}
