% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_add.R
\name{ph_add_text}
\alias{ph_add_text}
\title{append text}
\usage{
ph_add_text(x, str, type = NULL, id_chr = NULL, ph_label = NULL,
  style = fp_text(font.size = 0), pos = "after", href = NULL,
  slide_index = NULL)
}
\arguments{
\item{x}{a pptx device}

\item{str}{text to add}

\item{type}{placeholder type}

\item{id_chr}{placeholder id (a string). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.
Values can be read from \code{\link{slide_summary}}.}

\item{ph_label}{label associated to the placeholder. Use column
\code{ph_label} of result returned by \code{\link{slide_summary}}.
This should be used instead of using \code{type} and \code{id_chr}.}

\item{style}{text style, a \code{\link{fp_text}} object}

\item{pos}{where to add the new element relative to the cursor,
"after" or "before".}

\item{href}{hyperlink to reach when clicking the text}

\item{slide_index}{slide index to reach when clicking the text.
It will be ignored if \code{href} is not NULL.}
}
\description{
append text in a placeholder
}
\examples{
library(magrittr)
fileout <- tempfile(fileext = ".pptx")
my_pres <- read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_empty(location = ph_location_type(type = "body"))

small_red <- fp_text(color = "red", font.size = 14)

my_pres <- my_pres \%>\%
  ph_add_par(level = 3) \%>\%
  ph_add_text(str = "A small red text.", style = small_red) \%>\%
  ph_add_par(level = 2) \%>\%
  ph_add_text(str = "Level 2")

print(my_pres, target = fileout)

# another example ----
fileout <- tempfile(fileext = ".pptx")

doc <- read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_with("Un titre 2",
    location = ph_location_type(type = "title")) \%>\%
  ph_empty(location = ph_location(rotation = 90, bg = "red",
    label = "myph")) \%>\%
  ph_add_par(ph_label = "myph", level = 2) \%>\%
  ph_add_text(str = "Jump here to slide 2!", ph_label = "myph")

print(doc, target = fileout)
}
