% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dparallel.R
\name{dparallel}
\alias{dparallel}
\title{Compute Ohta's D Statistics in a manner optimized for parallelization}
\usage{
dparallel(data_set, tot_maf = 0.1, pop_maf = 0.05, comparisons_per_job,
  job_id, outfile = "Ohta")
}
\arguments{
\item{data_set}{The data set that is to be analysed.}

\item{tot_maf}{Minimum minor allele frequency across the total population for a marker to be included in the analysis.}

\item{pop_maf}{Minimum minor allele frequency across a subpopulation for that subpopulation to be included in analysis.}

\item{comparisons_per_job}{The number of comparisons that each instance of dparallel will compute.}

\item{job_id}{A number indicating that this is the nth instance of this function.}

\item{outfile}{Prefix for the file name that results will be written to. May be a path. Do not include extension.}
}
\description{
Infers the comparisons that this instance of the function is supposed to perform given job_id and comparisons_per_job.
Returns the results of those comparisons to an SQL database.
}
\examples{
data(beissinger_data)
dparallel(data_set = beissinger_data,
                     comparisons_per_job = 300,
                     job_id = 1,
                     outfile = tempfile(pattern = "beissinger_comparison", tmpdir = tempdir()))

}
