% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohortCodelist.R
\name{cohortCodelist}
\alias{cohortCodelist}
\title{Get codelist from a cohort_table object.}
\usage{
cohortCodelist(
  cohortTable,
  cohortId,
  type = c("index event", "inclusion criteria", "exclusion criteria", "exit criteria")
)
}
\arguments{
\item{cohortTable}{A cohort_table object.}

\item{cohortId}{A particular cohort definition id that is present in the
cohort table.}

\item{type}{The reason for the codelist. Can be "index event", "inclusion
criteria", or "exit criteria".}
}
\value{
A table with the codelists used.
}
\description{
Get codelist from a cohort_table object.
}
\examples{
 \donttest{
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

person <- tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2025-12-31"),
  period_type_concept_id = 0
)
cohort <- tibble(
  cohort_definition_id = c(1, 1, 1, 2),
  subject_id = 1,
  cohort_start_date = as.Date(c(
    "2020-01-01", "2021-01-01", "2022-01-01", "2022-01-01"
  )),
  cohort_end_date = as.Date(c(
    "2020-01-01", "2021-01-01", "2022-01-01", "2022-01-01"
  ))
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "my_example_cdm",
  cohortTables = list("cohort1" = cohort)
)
cdm$cohort1 <- newCohortTable(table = cdm$cohort1,
                                cohortCodelistRef = dplyr::tibble(
                                cohort_definition_id = c(1,1,1,2,2),
                                codelist_name =c("disease X", "disease X", "disease X",
                                                 "disease Y", "disease Y"),
                                concept_id = c(1,2,3,4,5),
                                type = "index event"
                              ))
cohortCodelist(cdm$cohort1, cohortId = 1, type = "index event")
}
}
