% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-solution.R
\name{get_row_duals}
\alias{get_row_duals}
\title{Gets the row duals of a solution}
\usage{
get_row_duals(solution)
}
\arguments{
\item{solution}{a solution}
}
\value{
Either a numeric vector with one element per row or `NA_real_`.
}
\description{
Gets the row duals of a solution
}
\examples{
\dontrun{
result <- MIPModel() \%>\%
  add_variable(x[i], i = 1:5) \%>\%
  add_variable(y[i, j], i = 1:5, j = 1:5) \%>\%
  add_constraint(x[i] >= 1, i = 1:5) \%>\%
  set_bounds(x[i], lb = 3, i = 1:3) \%>\%
  set_objective(sum_expr(i * x[i], i = 1:5)) \%>\%
  solve_model(with_ROI("glpk"))

get_row_duals(result)
}
}
