% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{record}
\alias{record}
\title{Recombination Counting and Ordering}
\usage{
record(input.seq, times = 10, LOD = 0, max.rf = 0.5, tol = 1e-04)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{times}{integer. Number of replicates of the RECORD procedure.}

\item{LOD}{minimum LOD-Score threshold used when constructing the pairwise
recombination fraction matrix.}

\item{max.rf}{maximum recombination fraction threshold used as the LOD
value above.}

\item{tol}{tolerance for the C routine, i.e., the value used to evaluate
convergence.}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{name of the object of class \code{onemap} with the raw
data.} \item{twopt}{name of the object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
Implements the marker ordering algorithm \emph{Recombination Counting and
Ordering} (\cite{Van Os et al., 2005}).
}
\details{
\emph{Recombination Counting and Ordering} (\emph{RECORD}) is an algorithm
for marker ordering in linkage groups. It is not an exhaustive search
method and, therefore, is not computationally intensive. However, it does
not guarantee that the best order is always found. The only requirement is
a matrix with recombination fractions between markers.

After determining the order with \emph{RECORD}, the final map is
constructed using the multipoint approach (function
\code{\link[onemap]{map}}).
}
\examples{

\dontrun{
  ##outcross example
  data(example_out)
  twopt <- rf_2pts(example_out)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)
  LG1 <- make_seq(groups,1)
  LG1.rec <- record(LG1)

  ##F2 example
  data(onemap_example_f2)
  twopt <- rf_2pts(onemap_example_f2)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)
  LG1 <- make_seq(groups,1)
  LG1.rec <- record(LG1)
  LG1.rec
}

}
\references{
Mollinari, M., Margarido, G. R. A., Vencovsky, R. and Garcia,
A. A. F. (2009) Evaluation of algorithms used to order markers on genetics
maps. \emph{Heredity} 103: 494-502.

Van Os, H., Stam, P., Visser, R.G.F. and Van Eck, H.J. (2005) RECORD: a
novel method for ordering loci on a genetic linkage map. \emph{Theoretical
and Applied Genetics} 112: 30-40.
}
\seealso{
\code{\link[onemap]{make_seq}} and \code{\link[onemap]{map}}
}
\author{
Marcelo Mollinari, \email{mmollina@usp.br}
}
\keyword{utilities}
