% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_seq.R
\name{group_seq}
\alias{group_seq}
\title{Assign markers to preexisting linkage groups}
\usage{
group_seq(input.2pts, seqs = "CHROM", unlink.mks = "all",
  rm.repeated = TRUE, LOD = NULL, max.rf = NULL)
}
\arguments{
\item{input.2pts}{an object of class \code{rf_2pts}.}

\item{seqs}{a list of objects of class \code{sequence} or the string
"CHROM" if there is \code{CHROM} information available in the input
data file.}

\item{unlink.mks}{a object of class \code{sequence} with the number of
the markers to be grouped with the preexisting sequences defined by \code{seqs}
parameter. Using the string "all", all remaining markers of
the \code{rf_2pts} object will be tested.}

\item{rm.repeated}{logical. If \code{TRUE}, markers grouped in more than
one of the sequences are keeped in the output sequences. If \code{FALSE},
they are removed of the output sequences.}

\item{LOD}{a (positive) real number used as minimum LOD score
(threshold) to declare linkage.}

\item{max.rf}{a real number (usually smaller than 0.5) used as
maximum recombination fraction to declare linkage.}
}
\value{
Returns an object of class \code{group_seq}, which is a list
    containing the following components: \item{data.name}{name of
    the object of class \code{onemap} that contains the raw
    data.} \item{twopt}{name of the object of class \code{rf.2ts}
    used as input, i.e., containing information used to assign
    markers to linkage groups.} \item{mk.names}{marker names,
    according to the input file.} \item{input.seqs}{list with the numbers
    of the markers in each inputted sequence}  \item{input.unlink.mks}{numbers of
    the unlinked markers in inputted sequence} \item{out.seqs}{list with the
    numbers of the markers in each outputted sequence} \item{n.unlinked}{number
    of markers that remained unlinked} \item{n.repeated}{number of markers which
    repeated in more than one group} \item{n.mar}{total number of markers evaluated}
    \item{LOD}{minimum LOD Score to declare linkage.} \item{max.rf}{maximum
    recombination fraction to declare linkage.} \item{sequences}{list of outputted
    sequences} \item{repeated}{list with the number of the markers that are repeated
    in each outputted sequence} \item{unlinked}{number of the markers which remained
    unlinked}
}
\description{
Identifies linkage groups of markers combining input \code{sequences} objects with
unlinked markers from \code{rf_2pts} object. The results from two-point
(pairwise) analysis and the \emph{transitive} property of linkage are used for
grouping, as \code{group} function.
}
\details{
If the arguments specifying thresholds used to group markers, i.e., minimum
LOD Score and maximum recombination fraction, are \code{NULL} (default),
the values used are those contained in object \code{input.2pts}. If not
using \code{NULL}, the new values override the ones in object
\code{input.2pts}.
}
\examples{
data(example_out) # load OneMap's fake dataset for a outcrossing population
data(vcf_example_out) # load OneMap's fake dataset from a VCF file for a outcrossing population
comb_example <- combine_onemap(example_out, vcf_example_out) # Combine datasets
twopts <- rf_2pts(comb_example)

out_CHROM <- group_seq(twopts, seqs="CHROM", rm.repeated=FALSE)
out_CHROM

seq1 <- make_seq(twopts, c(1,2,3,4,5,25,26))
seq2 <- make_seq(twopts, c(8,18))
seq3 <- make_seq(twopts, c(4,16,20,21,24,29))

out_seqs <- group_seq(twopts, seqs=list(seq1,seq2,seq3))
out_seqs


}
\seealso{
\code{\link[onemap]{make_seq}} and \code{\link[onemap]{group}}
}
\author{
Cristiane Taniguti, \email{chtaniguti@usp.br}
}
