% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onepass.R
\name{setup_op}
\alias{setup_op}
\title{Initialize vault and device}
\usage{
setup_op(
  domain,
  email,
  masterpassword = rstudioapi::askForPassword("Please enter your Master Password"),
  secretkey = rstudioapi::askForPassword("Please enter your Secret Key")
)
}
\arguments{
\item{domain}{Full domain URL of your vault}

\item{email}{Email address used on 1Password}

\item{masterpassword}{Used to unlock the vault}

\item{secretkey}{Used for enabling 1Password on new devices}
}
\value{
1Password session object, to be used for interacting with vault
}
\description{
If the device does not have an environment variable, creates one for the
session. This can be saved within the .Renviron file to reduce new device
alerts.
}
\details{
Saves a token as an environment variable for the session as OP_SESSION_(subdomain)
}
