% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.list.R
\name{as.data.list.data.frame}
\alias{as.data.list.data.frame}
\title{Convertion of data.frame into data.list}
\usage{
\method{as.data.list}{data.frame}(object)
}
\arguments{
\item{object}{The data.frame to be converted.}
}
\value{
a data.list
}
\description{
Convert a data.frame into a data.list
}
\details{
The convention is that columns with forecasts are postfixed with \code{.kxx} where
\code{xx} is the horizon. See the examples.
}
\examples{
# Convert a dataframe with time and two observed variables
X <- data.frame(t=1:10, x=1:10, y=1:10)
as.data.list(X)

# Convert a dataframe with time, forecast and an observed variable
X <- data.frame(t=1:10, x.k1=1:10, x.k2=10:1, yobs=1:10, y.k1=1:10, y.k2=1:10)
as.data.list(X)

# Can be converted back and forth
X
as.data.frame(as.data.list(X))

}
\seealso{
as.data.list

Other as.data.list: 
\code{\link{as.data.list}()}
}
\concept{as.data.list}
