## -----------------------------------------------------------------------------
# Load the package
library(onlineforecast)


## -----------------------------------------------------------------------------
# The data, just a rather short period to keep running times short
D <- subset(Dbuilding, c("2010-12-15", "2011-02-01"))
# Set the score period
D$scoreperiod <- in_range("2010-12-22", D$t)
#
D$tday <- make_tday(D$t, 1:36)


## -----------------------------------------------------------------------------
# Generate an input which is just random noise, i.e. should be removed in the selection
set.seed(83792)
D$noise <- make_input(rnorm(length(D$t)), 1:36)


## -----------------------------------------------------------------------------
# The full model
model <- forecastmodel$new()
# Set the model output
model$output = "heatload"
# Inputs (transformation step)
model$add_inputs(Ta = "Ta",
                 noise = "noise",
                 mu_tday = "fs(tday/24, nharmonics=4)",
                 mu = "one()")
# Regression step parameters
model$add_regprm("rls_prm(lambda=0.9)")
# Optimization bounds for parameters
model$add_prmbounds(lambda = c(0.9, 0.99, 0.9999))


## -----------------------------------------------------------------------------
# Select a model, just run optimization and score for a single horizon
model$kseq <- 5


## -----------------------------------------------------------------------------
# The range to select the number of harmonics parameter in
prm <- list(mu_tday__nharmonics = c(min=2, max=6))


## ---- message=FALSE, results="hide"-------------------------------------------
# Run the default selection, which is "both" and equivalent to "backwadboth"
# Note the control argument, which is passed to optim, it's now set to few
# iterations in the prm optimization
Lboth <- step_optim(model, D, prm, direction="both", control=list(maxit=1), mc.cores=1)


## -----------------------------------------------------------------------------
getse(Lboth, "model")


## ---- message=FALSE, results="hide"-------------------------------------------
Lforward <- step_optim(model, D, prm, "forward", control=list(maxit=1), mc.cores=1)

## -----------------------------------------------------------------------------
getse(Lforward, "model")


## ---- message=FALSE, results="hide"-------------------------------------------
Lbackward <- step_optim(model, D, prm, "backward", control=list(maxit=1), mc.cores=1)

## -----------------------------------------------------------------------------
getse(Lbackward, "model")


## ---- message=FALSE, results="hide"-------------------------------------------
# Clone the model to make a starting model
modelstart <- model$clone_deep()
# Remove two inputs
modelstart$inputs[2:3] <- NULL
# Run the selection
L <- step_optim(model, D, prm, modelstart=modelstart, control=list(maxit=1), mc.cores=1)

## -----------------------------------------------------------------------------
getse(L, "model")

