% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checker.R
\name{check}
\alias{check}
\alias{check.onnx_pb2.ModelProto}
\alias{check.onnx_pb2.GraphProto}
\alias{check.onnx_pb2.TensorProto}
\alias{check.onnx_pb2.AttributeProto}
\alias{check.onnx_pb2.NodeProto}
\title{Check Whether The Proto is Valid}
\usage{
check(proto, ir_version)

\method{check}{onnx_pb2.ModelProto}(proto, ir_version = 3L)

\method{check}{onnx_pb2.GraphProto}(proto, ir_version = 3L)

\method{check}{onnx_pb2.TensorProto}(proto, ir_version = 3L)

\method{check}{onnx_pb2.AttributeProto}(proto, ir_version = 3L)

\method{check}{onnx_pb2.NodeProto}(proto, ir_version = 3L)
}
\arguments{
\item{proto}{The proto}

\item{ir_version}{The version of the proto}
}
\description{
This method checks whether a protobuf in a particular type is valid.
}
\examples{
\dontrun{

library(onnx)

# Define a node protobuf and check whether it's valid
node_def <- make_node("Relu", list("X"), list("Y"))
check(node_def)

}
}
