% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{paramo}
\alias{paramo}
\title{PARAMO}
\usage{
paramo(rac_query, tree.list, ntrees)
}
\arguments{
\item{rac_query}{character list. Named list obtained from the RAC_query function.}

\item{tree.list}{multiSimmap or multiPhylo object. Named list with stochastic character maps.}

\item{ntrees}{integer. Number of trees to stack.}
}
\value{
A list of stacked stochastic character maps.
}
\description{
Wrapper function to perform the final paramo stacking of maps for a set of anatomy ontology terms.
}
\examples{
char_info <- hym_annot[1:2]
# Query for three anatomical regions.
terms <- c("head", "mesosoma", "metasoma")
query <- RAC_query(char_info, HAO, terms)
# Select the first three characters for each anatomical region.
query <- lapply(query, function(x) x[1:3])
# Subset the list of multiple maps.
tree_list <- hym_stm[unname(unlist(query))]
tree_list <- lapply(tree_list, function(x) discr_Simmap_all(x, res = 100))
tree_list_amalg <- paramo(query, tree_list, ntrees = 50)
tree_list_amalg <- lapply(tree_list_amalg, function(x) do.call(c,x) )
# Get one sample of map from head.
stm_hd <- tree_list_amalg$head[[1]]
# Get one sample of map from mesosoma.
stm_ms <- tree_list_amalg$mesosoma[[1]]
# Get one sample of map from metasoma.
stm_mt <- tree_list_amalg$metasoma[[1]]
# Plot one amalgamated stochastic map from each anatomical region.
phytools::plotSimmap(stm_hd, get_rough_state_cols(stm_hd), 
lwd = 3, pts = FALSE,ftype = "off")
phytools::plotSimmap(stm_ms, get_rough_state_cols(stm_ms), 
lwd = 3, pts = FALSE,ftype = "off")
phytools::plotSimmap(stm_mt, get_rough_state_cols(stm_mt), 
lwd = 3, pts = FALSE,ftype = "off")

}
\author{
Diego S. Porto
}
