% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmo.annotations.R
\name{harmo.annotate}
\alias{harmo.annotate}
\title{Set variable annotation with a taxonomy term}
\usage{
harmo.annotate(
  tibble,
  variables = NULL,
  taxonomy = "Mlstr_area",
  vocabulary,
  term
)
}
\arguments{
\item{tibble}{Tibble to be annotated.}

\item{variables}{A character vector of variable names to be annotated. If NULL or empty, all
the columns of the tibble will be annotated.}

\item{taxonomy}{The taxonomy to which the vocabulary belongs. If NULL, the annotation is a simple
attribute (i.e. without a taxonomy reference).}

\item{vocabulary}{The vocabulary to which the term belongs.}

\item{term}{The term to apply. If NULL, the annotation will be deleted.}
}
\value{
The annotated tibble
}
\description{
Apply or remove an annotation from a set of variables.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
cqx <- harmo.table_get(o, "CPTP", "Cag_coreqx")
cqx <- harmo.annotate(cqx, 
  variables = c("A_SDC_EDU_LEVEL", "A_SDC_EDU_LEVEL_AGE"), 
  taxonomy = "Mlstr_area", 
  vocabulary = "Sociodemographic_economic_characteristics", 
  term = "Education")
opal.logout(o)
}
}
