% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.token.R
\name{opal.token_r_create}
\alias{opal.token_r_create}
\title{Create a personal access token for R usage}
\usage{
opal.token_r_create(
  opal,
  name,
  projects = NULL,
  access = NULL,
  commands = c("export")
)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{Name of the token}

\item{projects}{Vector of project names, to which the token applies. Default is NULL (all projects).}

\item{access}{Data access level: 'READ' (read-only) or 'READ_NO_VALUES' (read-only, without access to individual-level data) or NULL (default).}

\item{commands}{Task commands that can launched on a project: 'import' and/or 'export'. Default is 'export' (use NULL for no task commands).}
}
\value{
The token value.
}
\description{
Create a personal access token for R (server) usage. Like for the other token functions, 
this operation requires the user to authenticate with username/password credentials.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
token <- opal.token_r_create(o, 'r-1', access = 'READ', commands = 'export')
opal.logout(o)
}
}
\seealso{
Other token functions: 
\code{\link{opal.token_datashield_create}()},
\code{\link{opal.token_delete}()},
\code{\link{opal.token_renew}()},
\code{\link{opal.token_sql_create}()},
\code{\link{opal.tokens}()},
\code{\link{opal.token}()}
}
\concept{token functions}
