% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_save}
\alias{opal.table_save}
\title{Save a local tibble as a Opal table}
\usage{
opal.table_save(
  opal,
  tibble,
  project,
  table,
  overwrite = TRUE,
  force = FALSE,
  identifiers = NULL,
  policy = "required",
  id.name = "id",
  type = "Participant"
)
}
\arguments{
\item{opal}{Opal connection object.}

\item{tibble}{The tibble object to be imported.}

\item{project}{Project name where the table will be located.}

\item{table}{Destination table name.}

\item{overwrite}{If the destination table already exists, it will be replaced (deleted, 
re-created with associated permissions reinstated and then imported). Otherwise the table
will be updated (data dictionaries merge may conflict). Default  is TRUE. See 
also \link{opal.table_truncate} function.}

\item{force}{If the destination already exists, stop with an informative message if this flag 
is FALSE (default).}

\item{identifiers}{Name of the identifiers mapping to use when assigning entities to Opal.}

\item{policy}{Identifiers policy: 'required' (each identifiers must be mapped prior importation 
(default)), ignore' (ignore unknown identifiers) and 'generate' (generate a system identifier for 
each unknown identifier).}

\item{id.name}{The name of the column representing the entity identifiers. Default is 'id'.}

\item{type}{Entity type (what the data are about). Default is 'Participant'}
}
\value{
An invisible logical indicating whether the destination table exists.
}
\description{
Upload a local tibble to the R server side through Opal, assign this tibble to the provided
symbol name and import it as a table into a Opal project.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
cqx <- opal.table_get(o, "CPTP", "Cag_coreqx")
# do some (meta)data transformations, then save in opal's database
opal.table_save(o, cqx, "CPTP", "Cag_coreqx", overwrite = TRUE, force = TRUE)
# or overwrite data only (keep original data dictionary)
opal.table_save(o, cqx, "CPTP", "Cag_coreqx", overwrite = 'values', force = TRUE)
opal.logout(o)
}
}
\seealso{
Other table functions: 
\code{\link{opal.perms}()},
\code{\link{opal.resource_view_create}()},
\code{\link{opal.resource_view_reconnect}()},
\code{\link{opal.table_create}()},
\code{\link{opal.table_delete}()},
\code{\link{opal.table_dictionary_get}()},
\code{\link{opal.table_dictionary_update}()},
\code{\link{opal.table_exists}()},
\code{\link{opal.table_export}()},
\code{\link{opal.table_get}()},
\code{\link{opal.table_import}()},
\code{\link{opal.table_perm_add}()},
\code{\link{opal.table_perm_delete}()},
\code{\link{opal.table_perm}()},
\code{\link{opal.table_truncate}()},
\code{\link{opal.table_view_create}()},
\code{\link{opal.table_view_update}()}
}
\concept{table functions}
