/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.mention;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.tools.coref.Linker;
import opennlp.tools.coref.mention.HeadFinder;
import opennlp.tools.coref.mention.Mention;
import opennlp.tools.coref.mention.MentionFinder;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.util.Span;

public abstract class AbstractMentionFinder
implements MentionFinder {
    protected HeadFinder headFinder;
    protected boolean collectPrenominalNamedEntities;
    protected boolean collectCoordinatedNounPhrases;

    private void gatherHeads(Parse p, Map heads) {
        Parse head = this.headFinder.getHead(p);
        if (head != null) {
            heads.put(head, p);
        }
        List nps = p.getNounPhrases();
        Iterator ni = nps.iterator();
        while (ni.hasNext()) {
            this.gatherHeads((Parse)ni.next(), heads);
        }
    }

    protected Map constructHeadMap(List nps) {
        HashMap headMap = new HashMap();
        for (int ni = 0; ni < nps.size(); ++ni) {
            Parse np = (Parse)nps.get(ni);
            this.gatherHeads(np, headMap);
        }
        return headMap;
    }

    public boolean isPrenominalNamedEntityCollection() {
        return this.collectPrenominalNamedEntities;
    }

    public void setPrenominalNamedEntityCollection(boolean b) {
        this.collectPrenominalNamedEntities = b;
    }

    protected boolean isBasalNounPhrase(Parse np) {
        return np.getNounPhrases().size() == 0;
    }

    protected boolean isPossessive(Parse np) {
        List ctoks;
        Parse tok;
        Parse child0;
        List parts = np.getSyntacticChildren();
        if (parts.size() > 1 && (child0 = (Parse)parts.get(0)).isNounPhrase() && (tok = (Parse)(ctoks = child0.getTokens()).get(ctoks.size() - 1)).getSyntacticType().equals("POS")) {
            return true;
        }
        if (parts.size() > 2) {
            child0 = (Parse)parts.get(0);
            Parse child1 = (Parse)parts.get(1);
            Parse child2 = (Parse)parts.get(2);
            if (child1.isToken() && child1.getSyntacticType().equals("POS") && child0.isNounPhrase() && child2.isNounPhrase()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isOfPrepPhrase(Parse np) {
        Parse child2;
        Parse child1;
        List cparts;
        Parse child0;
        List parts = np.getSyntacticChildren();
        return parts.size() == 2 && (child0 = (Parse)parts.get(0)).isNounPhrase() && (cparts = (child1 = (Parse)parts.get(1)).getSyntacticChildren()).size() == 2 && (child2 = (Parse)cparts.get(0)).isToken() && ((Object)child2).toString().equals("of");
    }

    protected boolean isConjoinedBasal(Parse np) {
        List parts = np.getSyntacticChildren();
        boolean allToken = true;
        boolean hasConjunction = false;
        for (int ti = 0; ti < parts.size(); ++ti) {
            Parse c = (Parse)parts.get(ti);
            if (c.isToken()) {
                if (!c.getSyntacticType().equals("CC")) continue;
                hasConjunction = true;
                continue;
            }
            allToken = false;
            break;
        }
        return allToken && hasConjunction;
    }

    private void collectCoordinatedNounPhraseMentions(Parse np, List entities) {
        List npTokens = np.getTokens();
        boolean inCoordinatedNounPhrase = false;
        int lastNpTokenIndex = this.headFinder.getHeadIndex(np);
        for (int ti = lastNpTokenIndex - 1; ti >= 0; --ti) {
            Mention snpExtent;
            Span npSpan;
            Parse tok = (Parse)npTokens.get(ti);
            String tokStr = ((Object)tok).toString();
            if (tokStr.equals("and") || tokStr.equals("or")) {
                if (lastNpTokenIndex != ti) {
                    if (ti - 1 < 0 || !((Parse)npTokens.get(ti - 1)).getSyntacticType().startsWith("NN")) break;
                    npSpan = new Span(((Parse)npTokens.get(ti + 1)).getSpan().getStart(), ((Parse)npTokens.get(lastNpTokenIndex)).getSpan().getEnd());
                    snpExtent = new Mention(npSpan, npSpan, tok.getEntityId(), null, "CNP");
                    entities.add(snpExtent);
                    inCoordinatedNounPhrase = true;
                }
                lastNpTokenIndex = ti - 1;
                continue;
            }
            if (inCoordinatedNounPhrase && tokStr.equals(",")) {
                if (lastNpTokenIndex != ti) {
                    npSpan = new Span(((Parse)npTokens.get(ti + 1)).getSpan().getStart(), ((Parse)npTokens.get(lastNpTokenIndex)).getSpan().getEnd());
                    snpExtent = new Mention(npSpan, npSpan, tok.getEntityId(), null, "CNP");
                    entities.add(snpExtent);
                }
                lastNpTokenIndex = ti - 1;
                continue;
            }
            if (!inCoordinatedNounPhrase || ti != 0 || lastNpTokenIndex < 0) continue;
            npSpan = new Span(((Parse)npTokens.get(ti)).getSpan().getStart(), ((Parse)npTokens.get(lastNpTokenIndex)).getSpan().getEnd());
            snpExtent = new Mention(npSpan, npSpan, tok.getEntityId(), null, "CNP");
            entities.add(snpExtent);
        }
    }

    private boolean handledPronoun(String tok) {
        return Linker.singularThirdPersonPronounPattern.matcher(tok.toString()).find() || Linker.pluralThirdPersonPronounPattern.matcher(tok.toString()).find() || Linker.speechPronounPattern.matcher(tok.toString()).find();
    }

    private void collectPossesivePronouns(Parse np, List entities) {
        List npTokens = np.getTokens();
        Parse headToken = this.headFinder.getHeadToken(np);
        for (int ti = npTokens.size() - 2; ti >= 0; --ti) {
            Parse tok = (Parse)npTokens.get(ti);
            if (tok == headToken || !tok.getSyntacticType().startsWith("PRP") || !this.handledPronoun(((Object)tok).toString())) continue;
            Mention ppExtent = new Mention(tok.getSpan(), tok.getSpan(), tok.getEntityId(), null, "np");
            entities.add(ppExtent);
            break;
        }
    }

    private void removeDuplicates(List extents) {
        Mention lastExtent = null;
        Iterator ei = extents.iterator();
        while (ei.hasNext()) {
            Mention e = (Mention)ei.next();
            if (lastExtent != null && e.getSpan().equals(lastExtent.getSpan())) {
                ei.remove();
                continue;
            }
            lastExtent = e;
        }
    }

    private boolean isHeadOfExistingMention(Parse np, Map headMap, Set mentions) {
        Parse head = (Parse)headMap.get(np);
        while (head != null) {
            if (mentions.contains(head)) {
                return true;
            }
            head = (Parse)headMap.get(head);
        }
        return false;
    }

    private void clearMentions(Set mentions, Parse np) {
        Span npSpan = np.getSpan();
        Iterator mi = mentions.iterator();
        while (mi.hasNext()) {
            Parse mention = (Parse)mi.next();
            if (mention.getSpan().contains(npSpan)) continue;
            mi.remove();
        }
    }

    private Mention[] collectMentions(List nps, Map headMap) {
        ArrayList<Mention> mentions = new ArrayList<Mention>(nps.size());
        HashSet<Parse> recentMentions = new HashSet<Parse>();
        int npl = nps.size();
        for (int npi = 0; npi < npl; ++npi) {
            Parse np = (Parse)nps.get(npi);
            if (!this.isHeadOfExistingMention(np, headMap, recentMentions)) {
                this.clearMentions(recentMentions, np);
                if (!this.isPartOfName(np)) {
                    Parse head = this.headFinder.getLastHead(np);
                    Mention extent = new Mention(np.getSpan(), head.getSpan(), head.getEntityId(), np, null);
                    mentions.add(extent);
                    recentMentions.add(np);
                    String entityType = this.getEntityType(this.headFinder.getHeadToken(head));
                    if (entityType != null) {
                        extent.setNameType(entityType);
                    }
                }
            }
            if (!this.isBasalNounPhrase(np)) continue;
            if (this.collectPrenominalNamedEntities) {
                this.collectPrenominalNamedEntities(np, mentions);
            }
            if (this.collectCoordinatedNounPhrases) {
                this.collectCoordinatedNounPhraseMentions(np, mentions);
            }
            this.collectPossesivePronouns(np, mentions);
        }
        Collections.sort(mentions);
        this.removeDuplicates(mentions);
        return mentions.toArray(new Mention[mentions.size()]);
    }

    private void addPossesiveMentions(Parse possesiveNounPhrase, List mentions) {
        Parse firstToken;
        List kids = possesiveNounPhrase.getSyntacticChildren();
        if (kids.size() > 1 && (firstToken = (Parse)kids.get(1)).isToken() && !firstToken.getSyntacticType().equals("POS")) {
            Parse lastToken = (Parse)kids.get(kids.size() - 1);
            if (lastToken.isToken()) {
                Span extentSpan = new Span(firstToken.getSpan().getStart(), lastToken.getSpan().getEnd());
                Mention extent = new Mention(extentSpan, extentSpan, -1, null, null);
                mentions.add(extent);
            } else {
                System.err.println("AbstractMentionFinder.addPossesiveMentions: odd parse structure: " + possesiveNounPhrase);
            }
        }
    }

    private void collectPrenominalNamedEntities(Parse np, List extents) {
        Parse htoken = this.headFinder.getHeadToken(np);
        List nes = np.getNamedEntities();
        Span headTokenSpan = htoken.getSpan();
        int nel = nes.size();
        for (int nei = 0; nei < nel; ++nei) {
            Parse ne = (Parse)nes.get(nei);
            if (ne.getSpan().contains(headTokenSpan)) continue;
            Mention extent = new Mention(ne.getSpan(), ne.getSpan(), ne.getEntityId(), null, "NAME");
            extent.setNameType(ne.getEntityType());
            extents.add(extent);
        }
    }

    private String getEntityType(Parse headToken) {
        Parse tchild;
        List tc;
        int tcs;
        String entityType;
        for (Parse parent = headToken.getParent(); parent != null; parent = parent.getParent()) {
            entityType = parent.getEntityType();
            if (entityType != null) {
                return entityType;
            }
            if (parent.isSentence()) break;
        }
        if ((tcs = (tc = headToken.getChildren()).size()) > 0 && (entityType = (tchild = (Parse)tc.get(tcs - 1)).getEntityType()) != null) {
            return entityType;
        }
        return null;
    }

    private boolean isPartOfName(Parse np) {
        for (Parse parent = np.getParent(); parent != null; parent = parent.getParent()) {
            String entityType = parent.getEntityType();
            if (entityType != null && !np.getSpan().contains(parent.getSpan())) {
                return true;
            }
            if (parent.isSentence()) break;
        }
        return false;
    }

    public List getNamedEntities(Parse p) {
        return p.getNamedEntities();
    }

    public Mention[] getMentions(Parse p) {
        List nps = p.getNounPhrases();
        Collections.sort(nps);
        Map headMap = this.constructHeadMap(nps);
        Mention[] mentions = this.collectMentions(nps, headMap);
        return mentions;
    }

    public boolean isCoordinatedNounPhraseCollection() {
        return this.collectCoordinatedNounPhrases;
    }

    public void setCoordinatedNounPhraseCollection(boolean b) {
        this.collectCoordinatedNounPhrases = b;
    }
}

