/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.spanish;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderME;

public class TokenChunker
extends NameFinderME {
    public TokenChunker(String modelName) throws IOException {
        this((MaxentModel)new SuffixSensitiveGISModelReader(new File(modelName)).getModel());
    }

    public TokenChunker(MaxentModel model) {
        super(model);
    }

    public TokenChunker(MaxentModel model, NameContextGenerator cg) {
        super(model, cg);
    }

    public TokenChunker(MaxentModel model, NameContextGenerator cg, int beamSize) {
        super(model, cg, beamSize);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: java opennlp.tools.spanish.TokenChunker model < tokenized_sentences");
            System.exit(1);
        }
        TokenChunker chunker = new TokenChunker(args[0]);
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in, "ISO-8859-1"));
        PrintStream out = new PrintStream((OutputStream)System.out, true, "ISO-8859-1");
        String line = inReader.readLine();
        while (line != null) {
            if (line.equals("")) {
                out.println();
            } else {
                Object[] tokens = line.split(" ");
                String[] chunks = chunker.find(tokens, Collections.EMPTY_MAP);
                int cn = chunks.length;
                for (int ci = 0; ci < cn; ++ci) {
                    if (ci == 0) {
                        out.print((String)tokens[ci]);
                        continue;
                    }
                    if (chunks[ci].equals("cont")) {
                        out.print("_" + (String)tokens[ci]);
                        continue;
                    }
                    out.print(" " + (String)tokens[ci]);
                }
                out.println();
            }
            line = inReader.readLine();
        }
    }
}

