/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import opennlp.maxent.DataStream;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.ChunkContextGenerator;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.chunking.Parser;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSContextGenerator;

public abstract class AbstractParserEventStream
implements EventStream {
    private ChunkerContextGenerator chunkerContextGenerator;
    private POSContextGenerator tagContextGenerator;
    private Event[] events;
    private int ei;
    private DataStream data;
    protected HeadRules rules;
    protected Set punctSet;
    protected ParserEventTypeEnum etype;
    protected boolean fixPossesives;
    protected Dictionary dict;

    public AbstractParserEventStream(DataStream d, HeadRules rules, ParserEventTypeEnum etype, Dictionary dict) {
        this.dict = dict;
        if (etype == ParserEventTypeEnum.CHUNK) {
            this.chunkerContextGenerator = new ChunkContextGenerator();
        } else if (etype == ParserEventTypeEnum.TAG) {
            this.tagContextGenerator = new DefaultPOSContextGenerator(null);
        }
        this.rules = rules;
        this.punctSet = rules.getPunctuationTags();
        this.etype = etype;
        this.data = d;
        this.ei = 0;
        this.init();
        if (d.hasNext()) {
            this.addNewEvents();
        } else {
            this.events = new Event[0];
        }
    }

    protected void init() {
        this.fixPossesives = false;
    }

    public AbstractParserEventStream(DataStream d, HeadRules rules, ParserEventTypeEnum etype) {
        this(d, rules, etype, null);
    }

    public Event nextEvent() {
        while (this.ei == this.events.length) {
            this.addNewEvents();
            this.ei = 0;
        }
        return this.events[this.ei++];
    }

    public boolean hasNext() {
        return this.ei < this.events.length || this.data.hasNext();
    }

    public static Parse[] getInitialChunks(Parse p) {
        ArrayList chunks = new ArrayList();
        AbstractParserEventStream.getInitialChunks(p, chunks);
        return chunks.toArray(new Parse[chunks.size()]);
    }

    private static void getInitialChunks(Parse p, List ichunks) {
        if (p.isPosTag()) {
            ichunks.add(p);
        } else {
            int ci;
            Parse[] kids = p.getChildren();
            boolean allKidsAreTags = true;
            int cl = kids.length;
            for (ci = 0; ci < cl; ++ci) {
                if (kids[ci].isPosTag()) continue;
                allKidsAreTags = false;
                break;
            }
            if (allKidsAreTags) {
                ichunks.add(p);
            } else {
                cl = kids.length;
                for (ci = 0; ci < cl; ++ci) {
                    AbstractParserEventStream.getInitialChunks(kids[ci], ichunks);
                }
            }
        }
    }

    private void addNewEvents() {
        String parseStr = (String)this.data.nextToken();
        ArrayList newEvents = new ArrayList();
        Parse p = Parse.parseParse(parseStr);
        Parse.pruneParse(p);
        if (this.fixPossesives) {
            Parse.fixPossesives(p);
        }
        p.updateHeads(this.rules);
        Parse[] chunks = AbstractParserEventStream.getInitialChunks(p);
        if (this.etype == ParserEventTypeEnum.TAG) {
            this.addTagEvents(newEvents, chunks);
        } else if (this.etype == ParserEventTypeEnum.CHUNK) {
            this.addChunkEvents(newEvents, chunks);
        } else {
            this.addParseEvents(newEvents, Parser.collapsePunctuation(chunks, this.punctSet));
        }
        this.events = newEvents.toArray(new Event[newEvents.size()]);
    }

    protected abstract void addParseEvents(List var1, Parse[] var2);

    private void addChunkEvents(List chunkEvents, Parse[] chunks) {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        int cl = chunks.length;
        for (int ci = 0; ci < cl; ++ci) {
            Parse c = chunks[ci];
            if (c.isPosTag()) {
                toks.add(c.toString());
                tags.add(c.getType());
                preds.add("O");
                continue;
            }
            boolean start = true;
            String ctype = c.getType();
            Parse[] kids = c.getChildren();
            int tl = kids.length;
            for (int ti = 0; ti < tl; ++ti) {
                Parse tok = kids[ti];
                toks.add(tok.toString());
                tags.add(tok.getType());
                if (start) {
                    preds.add("S-" + ctype);
                    start = false;
                    continue;
                }
                preds.add("C-" + ctype);
            }
        }
        int tl = toks.size();
        for (int ti = 0; ti < tl; ++ti) {
            chunkEvents.add(new Event((String)preds.get(ti), this.chunkerContextGenerator.getContext(ti, toks.toArray(), tags.toArray(new String[tags.size()]), preds.toArray(new String[preds.size()]))));
        }
    }

    private void addTagEvents(List tagEvents, Parse[] chunks) {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        int cl = chunks.length;
        for (int ci = 0; ci < cl; ++ci) {
            Parse c = chunks[ci];
            if (c.isPosTag()) {
                toks.add(c.toString());
                preds.add(c.getType());
                continue;
            }
            Parse[] kids = c.getChildren();
            int tl = kids.length;
            for (int ti = 0; ti < tl; ++ti) {
                Parse tok = kids[ti];
                toks.add(tok.toString());
                preds.add(tok.getType());
            }
        }
        int tl = toks.size();
        for (int ti = 0; ti < tl; ++ti) {
            tagEvents.add(new Event((String)preds.get(ti), this.tagContextGenerator.getContext(ti, toks.toArray(), preds.toArray(new String[preds.size()]), null)));
        }
    }

    protected boolean lastChild(Parse child, Parse parent) {
        Parse[] kids = AbstractBottomUpParser.collapsePunctuation(parent.getChildren(), this.punctSet);
        return kids[kids.length - 1] == child;
    }
}

