% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_attributes_sites_approx.R
\name{calc_attributes_sites_approx}
\alias{calc_attributes_sites_approx}
\title{Calculate attributes of the sites.}
\usage{
calc_attributes_sites_approx(sites_map = "sites", input_attr_name,
  output_attr_name = NULL, stat, round_dig = 2)
}
\arguments{
\item{sites_map}{character; name of the sites the attributes shall be
calculated for. "sites" refers to the observation sites.}

\item{input_attr_name}{character vector; input column name in the edges
attribute table.}

\item{output_attr_name}{character vector (optional); output column name
appended to the site attribute data table. If not provided it is set to
\code{input_attr_name}. Attribute names must not be longer than 10
characters.}

\item{stat}{name or character vector giving the statistics to be calculated.
See details below.}

\item{round_dig}{integer; number of digits to round results to.}
}
\value{
Nothing. The function appends new columns to the \code{sites_map}
  attribute table
\itemize{
 \item{'H2OAreaA':} {Total watershed area of the watershed upstream of each site.}
 \item{attr_name:} {Additional optional attributes calculated based on \code{input_attr_name}.}
}
}
\description{
For each site (observations or predictions) attributes (predictor variables)
are derived based on the values calculated for the edge the site lies on.
This function calculates approximate values for site catchments as described
in Peterson & Ver Hoef, 2014: STARS: An ArcGIS Toolset Used to Calculate the
Spatial Information Needed to Fit Spatial Statistical Models to Stream
Network Data. J. Stat. Softw., 56 (2).
}
\details{
The approximate total catchment area (H2OAreaA) is always calculated.
If \code{stat} is one of "min", "max", "mean" or "percent" the
  function assigns the value of the edge the site lies on. Otherwise, the
  value is calculated as the sum of all edges upstream of the previous
  junction and the proportional value of the edge the site lies on (based on
  the distance ratio 'ratio'); this is useful e.g. for counts of dams or waste water
  treatment plant or total catchment area.
}
\note{
\code{\link{import_data}}, \code{\link{derive_streams}},
  \code{\link{calc_edges}}, \code{\link{calc_sites}} or
  \code{\link{calc_prediction_sites}} and \code{\link{calc_attributes_edges}}
  must be run before.
}
\examples{
\donttest{
# Initiate GRASS session
if(.Platform$OS.type == "windows"){
  gisbase = "c:/Program Files/GRASS GIS 7.2.0"
  } else {
  gisbase = "/usr/lib/grass72/"
  }
initGRASS(gisBase = gisbase,
    home = tempdir(),
    override = TRUE)

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
setup_grass_environment(dem = dem_path, sites = sites_path)
import_data(dem = dem_path, sites = sites_path)
gmeta()

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 700, condition = TRUE, clean = TRUE)

# Check and correct complex junctions (there are no complex juctions in this 
# example date set)
cj <- check_compl_junctions()
if(cj){
  correct_compl_junctions()
}

# Prepare edges
calc_edges()

# Prepare site
calc_sites()

# Plot data
dem <- readRAST('dem', ignore.stderr = TRUE)
edges <- readVECT('edges', ignore.stderr = TRUE)
sites <- readVECT('sites', ignore.stderr = TRUE)
plot(dem, col = terrain.colors(20))
lines(edges, col = 'blue')
points(sites, pch = 4)
 }

}
\author{
Mira Kattwinkel, \email{mira.kattwinkel@gmx.net}
}
