% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oaApiRequest.R
\name{oa_fetch}
\alias{oa_fetch}
\title{A composition function to perform query building, requesting,
and convert the result to a tibble/data frame.}
\usage{
oa_fetch(
  ...,
  identifier = NULL,
  entity = if (is.null(identifier)) NULL else id_type(identifier[[1]]),
  search = NULL,
  sort = NULL,
  group_by = NULL,
  output = c("tibble", "dataframe", "list"),
  abstract = TRUE,
  endpoint = "https://api.openalex.org/",
  per_page = 200,
  count_only = FALSE,
  mailto = NULL,
  verbose = FALSE
)
}
\arguments{
\item{...}{Filter arguments. Filters narrow the list down to just entities that meet a particular condition--specifically, a particular value for a particular attribute.
Filters are formatted as attribute = value. The complete list of filter attributes for each entity can be found
For example, `cited_by_count = ">100"`,
`title.search = c("bibliometric analysis", "science mapping")`,
or `to_publication_date = "2021-12-31"`.
at \href{https://docs.openalex.org/api/get-lists-of-entities#filter}{https://docs.openalex.org/api/get-lists-of-entities#filter}}

\item{identifier}{Character. It indicates an item identifier.}

\item{entity}{Character. It indicates the scholarly entity of the search.
The argument can be one of c("works", "authors", "venues", "institutions", "concepts").
If not provided, `entity` is guessed from `identifier`.}

\item{search}{Character. Search is just another kind of filter, one that all five endpoints support. But unlike the other filters, search doesn't require an exact match.
To filter using search, append .search to the end of the property you're filtering for.}

\item{sort}{Character. Property to sort by.
For example: "display_name" for venues or "cited_by_count:desc" for works.
See more at <https://docs.openalex.org/api/get-lists-of-entities/sort-entity-lists>.}

\item{group_by}{Character. Property to group by.
For example: "oa_status" for works.
https://docs.openalex.org/api/get-groups-of-entities}

\item{output}{Character. Type of output, either a list or a tibble/data.frame.}

\item{abstract}{Logical. If TRUE, the function returns also the abstract of each item. Default is \code{abstract = TRUE}.
The argument is ignored if entity is different from "works".}

\item{endpoint}{is character. It indicates the url of the OpenAlex Endpoint API server. The default value is endpoint = "https://api.openalex.org/".}

\item{per_page}{is a numeric. It indicates how many items to download per page. The per-page argument can assume any number between 1 and 200. Default is \code{per_page=200}.}

\item{count_only}{is a logical. If TRUE, the function returns only the number of item matching the query. Default is \code{count_only=FALSE}.}

\item{mailto}{is a character. To get into the polite pool, the arguments mailto have to give OpenAlex an email where they can contact you.}

\item{verbose}{is a logical. If TRUE, information about the querying process will be plotted on screen. Default is \code{verbose=FALSE}.}
}
\value{
A data.frame or a list. Result of the query.
}
\description{
A composition function to perform query building, requesting,
and convert the result to a tibble/data frame.
}
\examples{
\dontrun{

paper_meta <- oa_fetch(
  identifier = "W2755950973",
  entity = "works",
  endpoint = "https://api.openalex.org/",
  count_only = TRUE,
  abstract = TRUE,
  verbose = TRUE
)

oa_fetch(
  entity = "works",
  doi = c(
    "10.1371/journal.pone.0266781",
    "10.1371/journal.pone.0267149"
  ),
  verbose = TRUE,
  count_only = TRUE
)

oa_fetch(
  entity = "works",
  doi = c(
    "10.1371/journal.pone.0266781",
    "10.1371/journal.pone.0267149"
  ),
  verbose = TRUE
)
}
}
