% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa2df.R
\name{concepts2df}
\alias{concepts2df}
\title{Convert OpenAlex collection of concepts' records from list format to data frame}
\usage{
concepts2df(data, verbose = TRUE)
}
\arguments{
\item{data}{List. Output of \code{oa_request}.}

\item{verbose}{Logical.
If TRUE, print information about the dataframe conversion process.
Defaults to TRUE.}
}
\value{
a data.frame.

For more extensive information about OpenAlex API, please visit: <https://docs.openalex.org>
}
\description{
It converts bibliographic collection of concepts' records gathered from OpenAlex database \href{https://openalex.org/}{https://openalex.org/} into data frame.
The function converts a list of concepts' records obtained using \code{oa_request} into a data frame/tibble.
}
\examples{
\dontrun{

# Query to search information about all Italian educational institutions


query_inst <- oa_query(
  entity = "concepts",
  display_name.search = "electrodynamics"
)

res <- oa_request(
  query_url = query_inst,
  count_only = FALSE,
  verbose = FALSE
)

df <- oa2df(res, entity = "concepts")

df
}

}
