context("test-show_package")

test_that("show_package has the correct return format.", {
  skip_on_cran()
  skip_if_offline()
  output <- show_package("c01c6d71-de1f-493d-91ba-364ce64884ac")
  expect_is(output, "tbl_df")
  expect_equal(names(output), package_cols)
  expect_is(output$title, "character")
  expect_is(output$id, "character")
  expect_is(output$topics, "character")
  expect_is(output$civic_issues, "character")
  expect_is(output$excerpt, "character")
  expect_is(output$dataset_category, "character")
  expect_is(output$formats, "character")
  expect_is(output$refresh_rate, "character")
  expect_is(output$num_resources, "integer")
  expect_is(output$last_refreshed, "Date")

  output <- show_package("https://open.toronto.ca/dataset/apartment-building-evaluation/")
  expect_is(output, "tbl_df")
  expect_equal(names(output), package_cols)
  expect_is(output$title, "character")
  expect_is(output$id, "character")
  expect_is(output$topics, "character")
  expect_is(output$civic_issues, "character")
  expect_is(output$excerpt, "character")
  expect_is(output$dataset_category, "character")
  expect_is(output$formats, "character")
  expect_is(output$refresh_rate, "character")
  expect_is(output$num_resources, "integer")
  expect_is(output$last_refreshed, "Date")

  output <- show_package("ttc-subway-shapefiles")
  expect_is(output, "tbl_df")
  expect_equal(names(output), package_cols)
  expect_is(output$title, "character")
  expect_is(output$id, "character")
  expect_is(output$topics, "character")
  expect_is(output$civic_issues, "character")
  expect_is(output$excerpt, "character")
  expect_is(output$dataset_category, "character")
  expect_is(output$formats, "character")
  expect_is(output$refresh_rate, "character")
  expect_is(output$num_resources, "integer")
  expect_is(output$last_refreshed, "Date")
})

test_that("show_package errors if offline", {
  with_mock(
    "curl::has_internet" = function() FALSE,
    expect_error(show_package("c01c6d71-de1f-493d-91ba-364ce64884ac"), "does not work offline")
  )
})
