% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nums.R
\name{get_num_instruments}
\alias{get_num_instruments}
\alias{get_num_samples}
\alias{get_num_channels}
\alias{get_num_orders}
\alias{get_num_patterns}
\alias{get_num_subsongs}
\alias{get_pattern_num_rows}
\title{Get element counts from an \code{openmpt} module}
\usage{
get_num_instruments(mod, ...)

get_num_samples(mod, ...)

get_num_channels(mod, ...)

get_num_orders(mod, ...)

get_num_patterns(mod, ...)

get_num_subsongs(mod, ...)

get_pattern_num_rows(mod, pattern)
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}.}

\item{...}{Ignored}

\item{pattern}{An \code{integer} pattern index (starting at 0) for which to
get count details.}
}
\value{
Returns an \code{integer} count of the requested information.
}
\description{
Functions that count specific elements in \code{openmpt} class objects and
returns the resulting number.
}
\examples{
mod <- demo_mod()
get_num_instruments(mod)
get_num_samples(mod)
get_num_channels(mod)
get_num_orders(mod)
get_num_patterns(mod)
get_num_subsongs(mod)
get_pattern_num_rows(mod, 0L)
}
