% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadWorkbook.R
\name{loadWorkbook}
\alias{loadWorkbook}
\title{Load an existing .xlsx file}
\usage{
loadWorkbook(file, xlsxFile = NULL, isUnzipped = FALSE, na.convert = TRUE)
}
\arguments{
\item{file}{A path to an existing .xlsx or .xlsm file}

\item{xlsxFile}{alias for file}

\item{isUnzipped}{Set to TRUE if the xlsx file is already unzipped}

\item{na.convert}{Should empty/blank cells be converted to \code{NA_character_}. Defaults to TRUE.}
}
\value{
Workbook object.
}
\description{
loadWorkbook returns a workbook object conserving styles and
formatting of the original .xlsx file.
}
\examples{
## load existing workbook from package folder
wb <- loadWorkbook(file = system.file("extdata", "loadExample.xlsx", package = "openxlsx"))
names(wb) # list worksheets
wb ## view object
## Add a worksheet
addWorksheet(wb, "A new worksheet")

## Save workbook
\dontrun{
saveWorkbook(wb, "loadExample.xlsx", overwrite = TRUE)
}

}
\seealso{
\code{\link[=removeWorksheet]{removeWorksheet()}}
}
\author{
Alexander Walker, Philipp Schauberger
}
