% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public.R
\name{oed_for_slope_over_intercept}
\alias{oed_for_slope_over_intercept}
\title{Create an optimal design for measuring the slope divided by the intercept}
\usage{
oed_for_slope_over_intercept(n, xmin, xmax, theta0, f_hetero = NULL,
  MaxIter = 6000, MaxFunEvals = 6000, TolFun = 1e-06,
  NUM_RAND_STARTS = 50)
}
\arguments{
\item{n}{The number of experimental runs.}

\item{xmin}{The minimum value of the independent variable.}

\item{xmax}{The maximum value of the independent variable.}

\item{theta0}{The guess of the true value of the slope / intercept.}

\item{f_hetero}{Specification of heteroskedasticity: the h(x) which relates the value of the 
independent variable to the variance in the response around the line at that place
or the proportional variance at that point. If \code{NULL}, homoskedasticity is
assumed (this is the default behavior).}

\item{MaxIter}{For the heteroskedastic design, a Nelder-Mead search is used (via the function \code{fminbnd}). 
This is the \code{MaxIter} value for the search. Default is \code{6000}. Lower if \code{n} is high.}

\item{MaxFunEvals}{For the heteroskedastic design, a Nelder-Mead search is used (via the function \code{fminbnd}). 
This is the \code{MaxFunEvals} value for the search. Default is \code{6000}. Lower if \code{n} is high.}

\item{TolFun}{For the heteroskedastic design, a Nelder-Mead search is used (via the function \code{fminbnd}). 
This is the \code{TolFun} value for the search. Default is \code{1e-6}. Increase for faster execution.}

\item{NUM_RAND_STARTS}{For the heteroskedastic design, a Nelder-Mead search is used (via the function \code{fminbnd}). 
The Nelder-Mead search must be given a starting location. Our implementation uses many
starting locations. This parameter controls the number of additional random starting
locations in the space \code{[xmin, xmax]}. Default is \code{50}.}
}
\value{
An n-vector of x-values which specifies the optimal design
}
\description{
Create an optimal design for measuring the slope divided by the intercept
}
\examples{
xmin = 5 / 15
xmax = 19 / 1
n = 10
theta0 = 0.053
opt_homo_design = oed_for_slope_over_intercept(n, xmin, xmax, theta0)
table(opt_homo_design)
}
\author{
Adam Kapelner
}

