% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_numtrees.R
\name{estimate_numtrees}
\alias{estimate_numtrees}
\title{Estimate the required number of trees}
\usage{
estimate_numtrees(
  optRF_object,
  measure = c("selection", "importance", "prediction"),
  for_stability = 0.95
)
}
\arguments{
\item{optRF_object}{An optRF_object, either the result from the \link{opt_importance} or the \link{opt_prediction} function.}

\item{measure}{A character string indicating which stability measure is to be analysed. One of "selection" (default, analyses selection stability), "prediction" (analyses prediction stability) or "importance" (analyses variable importance stability).}

\item{for_stability}{Either a single stability value or a vector containing multiple stability values for which the number of trees should be estimated.}
}
\value{
A data frame summarising the estimated stability and run time in seconds for the given num.trees values.
}
\description{
Estimate the number of trees required to achieve certain stability of random forest
}
\examples{
\donttest{
data(SNPdata)
set.seed(123)
result_optpred = opt_prediction(y = SNPdata[,1], X=SNPdata[,-1]) # optimise random forest
estimate_numtrees(result_optpred, measure="prediction", for_stability=0.95)
}

}
